////////////////////////////////////////////////////////////////////////////////
// KSI 2014-2015 1-3: Sirky
// Vypocet poctu sirek, ktere jsou v obecne variante na zacatku meho kola proherni
// Tento program slouzi pro jednoduche nastineni nekolika prohernich pozic
// main.c
// (c) Jan Horacek
// jan.horacek@seznam.cz
// v1.0
////////////////////////////////////////////////////////////////////////////////

// program prebira argumenty, kterymi se specifikuji povolene tahy
//  napr. program 1 2 -3 4
//   znamena, se program prebira povolene tahy 1,2 a 4, tah 3 je zakazany
//   vstupni data musi byt serazena od nejmensiho k nejvetsimu a vynechane tahy musi byt explicitne specifikovany

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

bool proh[1024] = {false, };                // tady se ukladaji proherni pocty (pokud je na indexy i true, je i proherni pocet)

int tahy[16];                               // povolene tahy
int tahy_cnt = 0;

int main(int argc, char* argv[])
{
	int start, end, i, j, tmp;
	bool vyh;

  // nactu povolene tahy
	tahy_cnt = argc-1;
	for (i = 1; i < argc; i++)
	{
		if (argv[i][0] == '-')
			proh[atoi(argv[i]+1)] = true;    // pokud tah zacina znakem '-', je vynechany -> je prohrany
		else {
			tmp = atoi(argv[i]);             // pokud je, zaradim ho mezi povolene tahy
			tahy[i-1] = tmp;
			printf("%d ", tmp);
		}
	}
	printf("\nArgs parsed : %d\n", tahy_cnt);

  // vsechny tahy od tahu 1 do prvniho povoleneho tahu jsou prohrane, protoze tento pocet sirek nemuzu ze stolu vzit
	for (i = 1; i < tahy[0]; i++)
		proh[i] = true;

  // urceni mezi for cyklu, kterym pocitam proherni tahy
	start = tahy[tahy_cnt-1]+1;
	end = start + 50;

  // debug vypis
	printf("Prohs before: ");
	for (i = 0; i < end; i++)
		if (proh[i]) printf("%d ", i);
	printf("\n");

  // pocitam proherni tahy:
  //  pokud se lze z aktualniho poctu sirek dostat povolenym tahem na proherni pocet, je tento pocet sirek pro me vyherni
  //  oduvodneni: kdyz tahnu a na hromadce zbyde proherni pocet, je to proherni pocet pro protihrace -> vyhravam
  // meze for cyklu jsou tu pro omezeni vypisu, protoze prohernich pozic je samozrejme nekonecne mnoho
	for (i = start; i < end; i++)
	{
		vyh = false;
		for (j = 0; j < tahy_cnt; j++)
		{
      // pokud se z aktualniho poctu dostanu libovlnym tahem na tah proherni, je pro me tato pozice vyherni
			tmp = i-tahy[j];                 // jaky bude pocet sirek po tahu tahy[j] ?
			if ((tmp >= 0) && (proh[tmp]))
				vyh = true;   // pocet sirek tmp je pro me vyherni a dostal jsem se na nej tahem tahy[j]
		}

		if (!vyh)         // pocet pro me neni vyherni -> tento pocet sirek je proherni
			proh[i] = true;
	}

  // vypis vystupu:
	printf("Pokud je na zacatku meho tahu tolik sirek, prohravam:\n");
	printf("0 ");   // s 0 sirek se samozrejme taky prohrava
	for (i = 0; i < end; i++)
		if (proh[i]) printf("%d ", i);
	printf("\n");

	return 0;
}
